/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.preview;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorInput;

public final class SourceConfig {
    private IEditorInput editorInput;
    private IProject project;
    private IPath location;
    private String content;
    private IFileStore fileStore;
    private IContentType contentType;

    public SourceConfig(IEditorInput editorInput, IProject project, IPath location, String content, IContentType contentType) {
        this.editorInput = editorInput;
        this.project = project;
        this.location = location;
        this.content = content;
        this.contentType = contentType;
        IPath path = location;
        if (project != null) {
            path = ResourcesPlugin.getWorkspace().getRoot().getFile(location).getLocation();
        }
        this.fileStore = EFS.getLocalFileSystem().getStore(path);
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getLocation() {
        return this.location;
    }

    public IFileStore getFileStore() {
        return this.fileStore;
    }

    public String getContent() {
        return this.content;
    }

    public IContentType getContentType() {
        return this.contentType;
    }
}

